'use strict';

/* API Includes */
var Site = require('dw/system/Site');
var CustomerMgr = require('dw/customer/CustomerMgr');
var cordial = require('../scripts/services/libCordial');
var Transaction = require('dw/system/Transaction');
var URLUtils = require('dw/web/URLUtils');

/* Script Modules */
var app = require('~/cartridge/scripts/app');
var guard = require('~/cartridge/scripts/guard');

function isNotFunctioon(method) {
    return method && {}.toString.call(method) !== '[object Function]';
}

/**
 * Customer dynamic mapping
 */
function customer() {
    var requestObject = request.httpParameterMap.requestBodyAsString;
    if (requestObject) {
        requestObject = '[' + requestObject + ']';
        var r = require("~/cartridge/scripts/util/Response");

        try {
            Transaction.wrap(function(){
                Site.getCurrent().setCustomPreferenceValue('cordialCustomerMapping', requestObject);
            });

            r.renderJSON({
                success: true,
                //message: 'Customer Attribute Key Mapping has been saved'
                message: 'To update all contact records in Cordial to reflect the new Customer Attribute Key mappings, a One-Time All Customers Export job should be run.'
            });
        } catch(e) {
            r.renderJSON({
                success: false,
                message: 'Not valid Customer Attribute Key Mapping'
            });
        }
    } else {
        var date = new Date();
        var searchProfile = CustomerMgr.searchProfile('creationDate <= {0}', date);
        var keys = Object.keys(searchProfile);
        var values = ['birthday', 'companyName', 'jobTitle', 'nextBirthday', 'phoneBusiness',
          'phoneMobile', 'preferredLocale', 'suffix', 'taxID', 'taxIDMasked', 'title'];

        keys.forEach(function (key) {
            //Remove deprecated fields and class declaration
            if (key !== 'saluation' && key !== 'class') {
                // Add custom fields names
                if (key === 'custom') {
                    var customObj = searchProfile.getCustom();
                    var customKeys = Object.keys(customObj);
                    customKeys.forEach(function(customKey) {
                        values.push('custom.' + customKey);
                    });
                } else if (key === 'credentials') {
                    var credentialObj = searchProfile.getCredentials();
                    var credentialKeys = Object.keys(credentialObj);
                    credentialKeys.forEach(function(credentialKey) {
                        if (isNotFunctioon(credentialObj[credentialKey])) {
                            values.push('credentials.' + credentialKey);
                        }
                    });
                } else if (isNotFunctioon(searchProfile[key])) {
                    values.push(key);
                }
            }
        });
    
        var service = cordial.getAccountContactAttributes();
    
        var reqObj = {};
    
        var result = service.call(JSON.stringify(reqObj));
    
        var object = JSON.parse(result.object)
        var cordialKeys = object ? Object.keys(object) : [];
    
        var cordialCustomerMapping = Site.getCurrent().getCustomPreferenceValue('cordialCustomerMapping');
        
        app.getView({
            sfccKeys: values.join(),
            cordialKeys: cordialKeys.join(),
            cordialCustomerMapping: cordialCustomerMapping,
            MENU_NAME: 'Cordial',
            URL: URLUtils.url('SiteNavigationBar-ShowMenuitemOverview', 'CurrentMenuItemId', 'cordial_id01'),
            TOP_URL: URLUtils.url('ViewApplication-SelectSite', 'MenuGroupID', 'ChannelMenu'),
            MAIN_MENU_NAME: 'Merchant Tools'
        }).render('cordial/customers');
    }
}

exports.Customer = guard.all(customer);
