/**
 * This controller provides different endpoints for calling Cordial services
 *
 * @module  controllers/cordial
 */

'use strict';

/* Script Modules */
var cordial = require('../scripts/services/libCordial');

function returnResponse(response, success, failed) {
    if (response.status === "OK") {
        // all good
        success();
    } else if(response.status === 401) {
        // wrong API key error
        failed('WRONG_API_KEY');
    } else {
        // response received, but not 200 or 401 code. other errors
        failed(response.msg);
    }
}

function getAccountContactAttributes(params, success, failed) {
    var service = cordial.getAccountContactAttributes();

    var reqObj = params || {};

    var result = service.call(JSON.stringify(reqObj));

    if (dw.system.Site.getCurrent().getCustomPreferenceValue('cordialEnabledLogs')) {
        var logger = Logger.getLogger('Cordial', 'cordial - get Account ContactAttributes');
        logger.debug('Calling params ' + params);
        logger.debug('Service result ' + result);
    }

    return returnResponse(result, success, failed);
}

/**
 * @see {@link module:controllers/Cordial~getAccountContactAttributes} */
 exports.GetAccountContactAttributes = getAccountContactAttributes;
