/* API Modules */
var LocalServiceRegistry = require('dw/svc/LocalServiceRegistry');
var Site = require('dw/system/Site');
var StringUtils = require('dw/util/StringUtils');


exports.getAccountContactAttributes = function () {
    var service = LocalServiceRegistry.createService("cordial.rest", {
        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("GET");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');

            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);

            svc.addParam('response_type', 'json');
            svc.setURL(svc.getURL() + 'accountcontactattributes');

            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};
