'use strict';

var autoComplete = (function(){
  function autoComplete(options){
      if (!document.querySelector) return;

      // helpers
      function hasClass(el, className){ return el.classList ? el.classList.contains(className) : new RegExp('\\b'+ className+'\\b').test(el.className); }

      function addEvent(el, type, handler){
          if (el.attachEvent) el.attachEvent('on'+type, handler); else el.addEventListener(type, handler);
      }
      function removeEvent(el, type, handler){
          // if (el.removeEventListener) not working in IE11
          if (el.detachEvent) el.detachEvent('on'+type, handler); else el.removeEventListener(type, handler);
      }
      function live(elClass, event, cb, context){
          addEvent(context || document, event, function(e){
              var found, el = e.target || e.srcElement;
              while (el && !(found = hasClass(el, elClass))) el = el.parentElement;
              if (found) cb.call(el, e);
          });
      }

      var o = {
          selector: 0,
          source: 0,
          minChars: 0,
          delay: 150,
          offsetLeft: 0,
          offsetTop: 1,
          cache: 1,
          menuClass: '',
          renderItem: function (item, search){
              // escape special characters
              search = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
              var re = new RegExp("(" + search.split(' ').join('|') + ")", "gi");
              return '<div class="autocomplete-suggestion" data-val="' + item + '">' + item.replace(re, "<b>$1</b>") + '</div>';
          },
          onSelect: function(e, term, item){}
      };
      for (var k in options) { if (options.hasOwnProperty(k)) o[k] = options[k]; }

      // init
      var elems = typeof o.selector == 'object' ? [o.selector] : document.querySelectorAll(o.selector);
      for (var i=0; i<elems.length; i++) {
          var that = elems[i];

          // create suggestions container "sc"
          that.sc = document.createElement('div');
          that.sc.className = 'autocomplete-suggestions '+o.menuClass;

          that.autocompleteAttr = that.getAttribute('autocomplete');
          that.setAttribute('autocomplete', 'off');
          that.cache = {};
          that.last_val = '';

          that.updateSC = function(resize, next){
              var rect = that.getBoundingClientRect();
              that.sc.style.left = Math.round(rect.left + (window.pageXOffset || document.documentElement.scrollLeft) + o.offsetLeft) + 'px';
              that.sc.style.top = Math.round(rect.bottom + (window.pageYOffset || document.documentElement.scrollTop) + o.offsetTop) + 'px';
              that.sc.style.width = Math.round(rect.right - rect.left) + 'px'; // outerWidth
              if (!resize) {
                  that.sc.style.display = 'block';
                  if (!that.sc.maxHeight) { that.sc.maxHeight = parseInt((window.getComputedStyle ? getComputedStyle(that.sc, null) : that.sc.currentStyle).maxHeight); }
                  if (!that.sc.suggestionHeight) that.sc.suggestionHeight = that.sc.querySelector('.autocomplete-suggestion').offsetHeight;
                  if (that.sc.suggestionHeight)
                      if (!next) that.sc.scrollTop = 0;
                      else {
                          var scrTop = that.sc.scrollTop, selTop = next.getBoundingClientRect().top - that.sc.getBoundingClientRect().top;
                          if (selTop + that.sc.suggestionHeight - that.sc.maxHeight > 0)
                              that.sc.scrollTop = selTop + that.sc.suggestionHeight + scrTop - that.sc.maxHeight;
                          else if (selTop < 0)
                              that.sc.scrollTop = selTop + scrTop;
                      }
              }
          }
          addEvent(window, 'resize', that.updateSC);
          document.body.appendChild(that.sc);

          live('autocomplete-suggestion', 'mouseleave', function(e){
              var sel = that.sc.querySelector('.autocomplete-suggestion.selected');
              if (sel) setTimeout(function(){ sel.className = sel.className.replace('selected', ''); }, 20);
          }, that.sc);

          live('autocomplete-suggestion', 'mouseover', function(e){
              var sel = that.sc.querySelector('.autocomplete-suggestion.selected');
              if (sel) sel.className = sel.className.replace('selected', '');
              this.className += ' selected';
          }, that.sc);

          live('autocomplete-suggestion', 'mousedown', function(e){
              if (hasClass(this, 'autocomplete-suggestion')) { // else outside click
                  var v = this.getAttribute('data-val');
                  that.value = v;
                  o.onSelect(e, v, this);
                  that.sc.style.display = 'none';
              }
          }, that.sc);

          that.blurHandler = function(){
              try { var over_sb = document.querySelector('.autocomplete-suggestions:hover'); } catch(e){ var over_sb = 0; }
              if (!over_sb) {
                  that.last_val = that.value;
                  that.sc.style.display = 'none';
                  setTimeout(function(){ that.sc.style.display = 'none'; }, 350); // hide suggestions on fast input
              } else if (that !== document.activeElement) setTimeout(function(){ that.focus(); }, 20);
          };
          addEvent(that, 'blur', that.blurHandler);

          var suggest = function(data){
              var val = that.value;
              that.cache[val] = data;
              if (data.length && val.length >= o.minChars) {
                  var s = '';
                  for (var i=0;i<data.length;i++) s += o.renderItem(data[i], val);
                  that.sc.innerHTML = s;
                  that.updateSC(0);
              }
              else
                  that.sc.style.display = 'none';
          }

          that.keydownHandler = function(e){
              var key = window.event ? e.keyCode : e.which;
              // down (40), up (38)
              if ((key == 40 || key == 38) && that.sc.innerHTML) {
                  var next, sel = that.sc.querySelector('.autocomplete-suggestion.selected');
                  if (!sel) {
                      next = (key == 40) ? that.sc.querySelector('.autocomplete-suggestion') : that.sc.childNodes[that.sc.childNodes.length - 1]; // first : last
                      next.className += ' selected';
                      that.value = next.getAttribute('data-val');
                  } else {
                      next = (key == 40) ? sel.nextSibling : sel.previousSibling;
                      if (next) {
                          sel.className = sel.className.replace('selected', '');
                          next.className += ' selected';
                          that.value = next.getAttribute('data-val');
                      }
                      else { sel.className = sel.className.replace('selected', ''); that.value = that.last_val; next = 0; }
                  }
                  that.updateSC(0, next);
                  return false;
              }
              // esc
              else if (key == 27) { that.value = that.last_val; that.sc.style.display = 'none'; }
              // enter
              else if (key == 13 || key == 9) {
                  var sel = that.sc.querySelector('.autocomplete-suggestion.selected');
                  if (sel && that.sc.style.display != 'none') { o.onSelect(e, sel.getAttribute('data-val'), sel); setTimeout(function(){ that.sc.style.display = 'none'; }, 20); }
              }
          };
          addEvent(that, 'keydown', that.keydownHandler);

          that.keyupHandler = function(e){
              var key = window.event ? e.keyCode : e.which;
              if (!key || (key < 35 || key > 40) && key != 13 && key != 27) {
                  var val = that.value;
                  if (val.length >= o.minChars) {
                      if (val != that.last_val) {
                          that.last_val = val;
                          clearTimeout(that.timer);
                          if (o.cache) {
                              if (val in that.cache) { suggest(that.cache[val]); return; }
                              // no requests if previous suggestions were empty
                              for (var i=1; i<val.length-o.minChars; i++) {
                                  var part = val.slice(0, val.length-i);
                                  if (part in that.cache && !that.cache[part].length) { suggest([]); return; }
                              }
                          }
                          that.timer = setTimeout(function(){ o.source(val, suggest) }, o.delay);
                      }
                  } else {
                      that.last_val = val;
                      that.sc.style.display = 'none';
                  }
              }
          };
          addEvent(that, 'keyup', that.keyupHandler);

          that.focusHandler = function(e){
              that.last_val = '\n';
              that.keyupHandler(e)
          };
          if (!o.minChars) addEvent(that, 'focus', that.focusHandler);
      }

      // public destroy method
      this.destroy = function(){
          for (var i=0; i<elems.length; i++) {
              var that = elems[i];
              removeEvent(window, 'resize', that.updateSC);
              removeEvent(that, 'blur', that.blurHandler);
              removeEvent(that, 'focus', that.focusHandler);
              removeEvent(that, 'keydown', that.keydownHandler);
              removeEvent(that, 'keyup', that.keyupHandler);
              if (that.autocompleteAttr)
                  that.setAttribute('autocomplete', that.autocompleteAttr);
              else
                  that.removeAttribute('autocomplete');
              document.body.removeChild(that.sc);
              that = null;
          }
      };
  }
  return autoComplete;
})();

(function(){
  if (typeof define === 'function' && define.amd)
      define('autoComplete', function () { return autoComplete; });
  else if (typeof module !== 'undefined' && module.exports)
      module.exports = autoComplete;
  else
      window.autoComplete = autoComplete;
})();

var elementSfccKeys = document.querySelector('.sfccKeys');
var elementCordialKeys = document.querySelector('.cordialKeys');

new autoComplete({
  selector: elementSfccKeys,
  source: function (term, suggest){
    term = term.toLowerCase();
    var matches = [];
    var arr = elementSfccKeys.dataset.autocomplete.split(',');

    for (var i=0; i<arr.length; i++) {
      if (~arr[i].toLowerCase().indexOf(term)) {
        if (arr[i] !== term) {
          matches.push(arr[i]);
        }
      }
    }
        
    suggest(matches);
  },
});

new autoComplete({
  selector: elementCordialKeys,
  source: function (term, suggest){
    term = term.toLowerCase();
    var matches = [];
    var arr = elementCordialKeys.dataset.autocomplete.split(',');
    for (var i=0; i<arr.length; i++) {
      if (~arr[i].toLowerCase().indexOf(term)) {
        if (arr[i] !== term) {
          matches.push(arr[i]);
        }
      }
    }
    suggest(matches);
  }
});

var addElements = document.querySelector('.addElements');
var removeElements = document.querySelector('.remove-field');

function removeFields(e) {
  e.preventDefault();
  var table = document.querySelector('.table-fields tbody');
  var count = Number.parseInt(table.dataset.count);

  if (count !== 0) {
    var mainAutocompleteField = e.target.closest('.autocomplete-fields');
    mainAutocompleteField.remove();
    table.dataset.count = count - 1;
  }
}

function addFields(e) {
  if (e) {
    e.preventDefault();
  }
  var autocompleteFields = document.querySelector('.autocomplete-fields');
  var table = document.querySelector('.table-fields tbody');
  var count = Number.parseInt(table.dataset.count) + 1;

  var clone = autocompleteFields.cloneNode(true);

  var inputList = clone.querySelectorAll('input');
  inputList.forEach(function (input) {
    input.name = input.name + '-' + count;
    input.value = '';
  });


  table.appendChild(clone);

  var elementSfccKeys = clone.querySelector('.sfccKeys');
  var elementCordialKeys = clone.querySelector('.cordialKeys');
  var removeElement = clone.querySelector('.remove-field');

  removeElement.onclick = removeFields;
  table.dataset.count = count;
  new autoComplete({
    selector: elementSfccKeys,
    source: function (term, suggest){
      term = term.toLowerCase();
      var matches = [];
      var arr = elementSfccKeys.dataset.autocomplete.split(',');
  
      for (var i=0; i<arr.length; i++) {
        if (~arr[i].toLowerCase().indexOf(term)) {
          if (arr[i] !== term) {
            matches.push(arr[i]);
          }
        }
      }
      suggest(matches);
    }
  });
  
  new autoComplete({
    selector: elementCordialKeys,
    source: function (term, suggest){
      term = term.toLowerCase();
      var matches = [];
      var arr = elementCordialKeys.dataset.autocomplete.split(',');
      for (var i=0; i<arr.length; i++) {
        if (~arr[i].toLowerCase().indexOf(term)) {
          if (arr[i] !== term) {
            matches.push(arr[i]);
          }
        }
      }
      suggest(matches);
    }
  });
}

addElements.onclick = addFields;

removeElements.onclick = removeFields;


var form = document.querySelector('#saveDynamicFields');

var serialize = function (form) {

  // Setup our serialized data
  var serialized = [];
  var serializedStr = [];

  // Loop through each field in the form
  for (var i = 0; i < form.elements.length; i++) {

    var field = form.elements[i];

    // Don't serialize fields without a name, submits, buttons, file and reset inputs, and disabled fields
    if (!field.name || field.disabled || field.type === 'file' || field.type === 'reset' || field.type === 'submit' || field.type === 'button') continue;

    var name = field.name;
    var tag = name.match(/(sf|cordial)-?(\d+)?/);
    if (!tag) continue;

    var key = tag[2] || 0;
    if (serialized[key] === undefined) {
      serialized[key] = {};
    }
    serialized[key][tag[1]] = field.value;

    if (serialized[key].hasOwnProperty('sf') && serialized[key].hasOwnProperty('cordial')) {
      serializedStr.push(JSON.stringify(serialized[key]));
    }
  }

  return serializedStr.join(',');

};

form.addEventListener('submit', function (event) {
  event.preventDefault();
  let formAction = event.target.getAttribute("action");
  var status = document.querySelector('.status');
  status.innerHTML = '';
  status.className = 'status';
  fetch(formAction, {
      method: 'POST',
      body: serialize(event.target),
      headers: {
        'Content-type': 'application/json; charset=UTF-8'
      }
    }).then((response) => {
      return response.json();
    })
    .then((data) => {
      status.classList.add(data.success ? 'status__ok' : 'status__false');
      status.innerHTML = data.message;
      setTimeout(function() {
        status.innerHTML = '';
        status.className = 'status';
      }, 3000);
    });
});

var cordialCustomerMapping = document.querySelector('.cordialCustomerMapping');

if (cordialCustomerMapping && cordialCustomerMapping.value) {
  var json = cordialCustomerMapping.value;
  var newJson = json.replace(/([a-zA-Z0-9]+?):/g, '"$1":');
  newJson = newJson.replace(/'/g, '"');
  var cordialCustomerMappingArray = JSON.parse(newJson);
  if (cordialCustomerMappingArray) {
    cordialCustomerMappingArray.forEach(function (mapping, key, arr) {
      var sfField;
      var cordialField;
      if (key === 0) {
        sfField = document.querySelector('[name=sf]');
        cordialField = document.querySelector('[name=cordial]');
        sfField.value = mapping.sf;
        cordialField.value = mapping.cordial;
      } else {
        sfField = document.querySelector('[name=sf-' + key + ']');
        cordialField = document.querySelector('[name=cordial-' + key + ']');
        sfField.value = mapping.sf;
        cordialField.value = mapping.cordial;
      }
      if (key !== arr.length - 1) {
        addFields();
      }
    });
  }

}