'use strict';

var form = document.querySelector('#checkApiKey');

var serializeForm = function (form) {
	var obj = {};
	var formData = new FormData(form);
	for (var key of formData.keys()) {
		obj[key] = formData.get(key);
	}
	return obj;
};

form.addEventListener('submit', function (event) {
	event.preventDefault();
  var formAction = event.target.getAttribute("action");
var status = document.querySelector('.status');
status.innerHTML = '';
status.className = 'status';
	fetch(formAction, {
		method: 'POST',
		body: JSON.stringify(serializeForm(event.target)),
		headers: {
			'Content-type': 'application/json; charset=UTF-8'
		}
	}).then((response) => {
		return response.json();
	  })
	  .then((data) => {
		status.classList.add(data.success ? 'status__ok' : 'status__false');
		status.innerHTML = data.message;
	  });

});