'use strict';

/* Script Modules */
var guard = require('*/cartridge/scripts/guard');
var Logger = require('dw/system/Logger');
/* API Includes */
var ISML = require('dw/template/ISML');


/**
 * Controller that will send the necessary data required for cordial to track the user event's
 * such as checkout,order confirmation,searching etc and renders the renders the cordialTag isml file
 *
 * @module controllers/cordial
*/


var RenderCordial = function () {
    if (!dw.system.Site.getCurrent().getCustomPreferenceValue('cordialEnabledTag')) {
        return;
    }
    var logger = Logger.getLogger('renderCordial', 'cordial - Render cordial Controller');
    try {
        var cordialUtils = require('*/cartridge/scripts/utils/cordial/cordialUtils');
        var cordialTags = require('*/cartridge/scripts/utils/cordial/cordialOnSiteTags.js').cordialOnSiteTags;

        var cordialDataLayer = cordialUtils.buildDataLayer();
        var sendToDom = cordialTags(cordialDataLayer);

        var subscribed = customer && customer.profile && customer.profile.custom.cordialSubscribed;
        if (subscribed == 'yes') subscribed = 'subscribed';
        if (subscribed == 'no') subscribed = 'none';

        var email = customer && customer.profile && customer.profile.email  

        if (cordialDataLayer.event === 'updating_cart' || cordialDataLayer.event === 'new_order') {
            ISML.renderTemplate('cordial/cordialTagCart', {
                cordialData: sendToDom,
                cordialEmail: email,
                subscribed: subscribed
            });
        } else {
            //logger.debug('rendering--cordialTagCart: ' + cordialDataLayer.event);
            ISML.renderTemplate('cordial/cordialTag', {
                controllerName: (cordialDataLayer.controllerName),
                cordialData: sendToDom,
                cordialEmail: email, 
                subscribed: subscribed
            });
        }

    } catch (e) {
        logger.debug('error rendering cordial ' + e.message + ' at ' + e.lineNumber);
    }
};

/**
 * Controller that will send the necessary data  to cordial when an add to cart event happens
 * @module controllers/cordial
*/


var RenderCordialAddToCart = function () {
    if (!dw.system.Site.getCurrent().getCustomPreferenceValue('cordialEnabledTag')) {
        return;
    }
    var logger = Logger.getLogger('renderCordial', 'cordial - Render cordial add to cart Controller');

    try {
      var cordialUtils = require('*/cartridge/scripts/utils/cordial/cordialUtils');
      var cordialTags = require('*/cartridge/scripts/utils/cordial/cordialOnSiteTags.js').cordialOnSiteTags;

      var cordialDataLayer = cordialUtils.buildCartDataLayer();
      var sendToDom = cordialTags(cordialDataLayer);

      ISML.renderTemplate('cordial/cordialTagCart', {
        cordialData: sendToDom
      });
    } catch (e) {
      logger.debug('error Render cordial add to cart ' + e.message + ' at ' + e.lineNumber);
    }
};

/** Handles render isml for cardial tag
 * @see {@link module:controllers/cordial~Subscribe} */
exports.RenderCordial = guard.ensure(['get'], RenderCordial);
exports.RenderCordialAddToCart = guard.ensure(['get'], RenderCordialAddToCart);
