'use strict';


var OrderMgr = require('dw/order/OrderMgr');
var Transaction = require('dw/system/Transaction');

/**
 * 
 * This function import subscribe Statuses
 */
function changeOrderStatus(options) {
  var searchOrder;
  searchOrder = OrderMgr.getOrder(options.orderNumber);

  if (searchOrder) {

    if (options.orderStatus === 'ORDER_STATUS_CANCELLED') {
      Transaction.wrap(function () {
        OrderMgr.cancelOrder(searchOrder);
      })
      return;
    }

    if (options.orderStatus === 'ORDER_STATUS_NEW') {
      Transaction.wrap(function () {
        searchOrder.setStatus(3);
      })
      return;
    }

    if (options.orderStatus === 'ORDER_STATUS_OPEN') {
      Transaction.wrap(function () {
        searchOrder.setStatus(4);
      })
      return;
    }

    if (options.orderStatus === 'ORDER_STATUS_COMPLETED') {
      Transaction.wrap(function () {
        searchOrder.setStatus(5);
      })
      return;
    }

    if (options.orderStatus === 'ORDER_STATUS_REPLACED') {
       Transaction.wrap(function () {
        searchOrder.setStatus(7);
      })
      return;
    }


    if (options.orderStatus === 'SHIPPING_STATUS_NOTSHIPPED') {
      Transaction.wrap(function () {
        searchOrder.setShippingStatus(0);
      })
      return;
    }

    if (options.orderStatus === 'SHIPPING_STATUS_PARTSHIPPED') {
      Transaction.wrap(function () {
        searchOrder.setShippingStatus(1);
      })
      return;
    }

    if (options.orderStatus === 'SHIPPING_STATUS_SHIPPED') {
      Transaction.wrap(function () {
        searchOrder.setShippingStatus(2);
      })
      return;
    }
  }
}


module.exports = {
  changeOrderStatus: changeOrderStatus
};
