'use strict';

var OrderMgr = require('dw/order/OrderMgr');
var Site = require('dw/system/Site');
var Transaction = require('dw/system/Transaction');
var Logger = require('dw/system/Logger');
var OrderMapping = require('int_cordial_core/cartridge/scripts/lib/mapping/order');
var CustomObjectMgr = require('dw/object/CustomObjectMgr');
var FileWriter = require('dw/io/FileWriter');
var File = require('dw/io/File');
var cordial = require('~/cartridge/scripts/services/cordial');
var helper = require('~/cartridge/scripts/lib/mapping/helper/helper');

/**
 * exportOrders
 * This function export orders
 * JOB: Recurring Orders Export
 * Export-Orders
 * Custom.Cordial.ExportOrders
 **/
function exportOrders(options) {
  var searchOrders;

  var lastRunObject = CustomObjectMgr.getCustomObject('CORDIAL_LASTRUN', 'cordialOrdersDateUpdate');
  if (!lastRunObject) {
    Transaction.wrap(function () {
        lastRunObject =
            CustomObjectMgr.createCustomObject('CORDIAL_LASTRUN', 'cordialOrdersDateUpdate');
    });
  }

  var cordialOrdersDateUpdate = lastRunObject.custom.lastRunTime
        ? lastRunObject.custom.lastRunTime
        : Site.getCurrent().getCustomPreferenceValue('cordialOrdersDateUpdate');

  var newCordialOrdersDateUpdate = helper.getTime();
  var errorFlag = false;


  // TODO cordialOrdersDateUpdate
  if (cordialOrdersDateUpdate) {
    searchOrders = OrderMgr.queryOrders('lastModified >= {0}', null, cordialOrdersDateUpdate);
  } else {
    var date = newCordialOrdersDateUpdate;
    searchOrders = OrderMgr.queryOrders('creationDate <= {0}', null, date);
  }

  while (searchOrders.hasNext()) {
    var order = searchOrders.next();

    Logger.info('cordialOrdersDateUpdate--updateOrder {0}', order.getOrderNo());

    cordial.GetOrders(order.getOrderNo(), function (response) {
      var oldOrder = JSON.parse(response.object);

      cordial.PostOrders(order, function () {}, function (response) {
        errorFlag = true;
        Logger.error('Import order error on posting Update: {0} ', response);
      }, oldOrder);
    }, function () {
      cordial.PostOrders(order, function () {}, function (r) {
          errorFlag = true;
          Logger.error('Import order error on posting new order: {0} ', r);
      });
    });
  }

  if (!errorFlag) {
    try {
        Transaction.wrap(function () {
            Site.getCurrent().setCustomPreferenceValue('cordialOrdersDateUpdate',
                newCordialOrdersDateUpdate);
        });
        Transaction.wrap(function () {
            lastRunObject.custom.lastRunTime = newCordialOrdersDateUpdate;
        });
    } catch (e) {
        Logger.info(['finish-newCordialOrdersDateUpdate', newCordialOrdersDateUpdate]);
    }

    Logger.info(
        'cordialOrdersDateUpdate--job-run {0} ={1}',
        newCordialOrdersDateUpdate,
        searchOrders.getCount()
    );
  } else {
    throw new Error('Job failed due to error(s) above.');
  }
}

/**
 * This function export orders files
 **/
function exportOrdersFile(options) {
    var searchOrders;
    var newCordialOrdersDateUpdate = helper.getTime();

    var lastRunObject = CustomObjectMgr.getCustomObject('CORDIAL_LASTRUN', 'cordialOrdersDateUpdate');
    if (!lastRunObject) {
        Transaction.wrap(function () {
            lastRunObject =
                CustomObjectMgr.createCustomObject('CORDIAL_LASTRUN', 'cordialOrdersDateUpdate');
        });
    }

    var cordialOrdersDateUpdate = lastRunObject.custom.lastRunTime
        ? lastRunObject.custom.lastRunTime
        : Site.getCurrent().getCustomPreferenceValue('cordialOrdersDateUpdate');

    if (!cordialOrdersDateUpdate) {
            cordialOrdersDateUpdate = newCordialOrdersDateUpdate;

            try {
                Transaction.wrap(function () {
                    Site.getCurrent().setCustomPreferenceValue('cordialOrdersDateUpdate',
                        newCordialOrdersDateUpdate);
                });
                Transaction.wrap(function () {
                    lastRunObject.custom.lastRunTime = newCordialOrdersDateUpdate;
                });
            } catch (e) {
                Logger.info(['finish-newCordialOrdersDateUpdate', newCordialOrdersDateUpdate]);
            }
    }

    searchOrders = OrderMgr.queryOrders(
        '(custom.cordialLastExported < {0} OR custom.cordialLastExported = NULL)',
        //'creationDate <= {0}',
        null,
        cordialOrdersDateUpdate
    );

    Logger.info(['call-exportOrdersFile', searchOrders.getCount(), cordialOrdersDateUpdate, Site.getCurrent().getCustomPreferenceValue('cordialOrdersDateUpdate')]);
    exportOrdersFileRuner(options, searchOrders, 999999999);
}


function exportOrdersFileTestRun(options) {
	  var searchOrders;
	  var newCordialOrdersDateUpdate = helper.getTime();

	  var date = newCordialOrdersDateUpdate;
	  searchOrders = OrderMgr.queryOrders('creationDate <= {0}', null, date);

	  exportOrdersFileRuner(options, searchOrders, 100);
}


function longJobTestRun(options) {
		var startTime = helper.getTime();
		var finalTime = helper.getTime();
		var millisecondsToWait = 300 * 60 * 60 * 1000; // vary this depending on your "sleep" needs

        while (finalTime - startTime < millisecondsToWait) {
		    finalTime = helper.getTime();
		}
}


/**
 *  Generate CSV for Export
 **/
function exportOrdersFileRuner(options, searchOrders, limit) {
  var newCordialOrdersDateUpdate = helper.getTime();
  var date = newCordialOrdersDateUpdate;
  var counter = 0;
  var errorFlag = false;

  if (searchOrders.hasNext()) {
    //Create jsonl
    var siteID = Site.getCurrent().getID(),
      exportFolderPath = File.IMPEX + "/cordial/",
      exportFolder = new File(exportFolderPath);

    if (!exportFolder.exists()) {
      exportFolder.mkdirs();
    }

    var exportFilename = exportFolder.fullPath + "orders_"
        + helper.getTimestamp() + ".json";
    var exportFile = new File(exportFilename),
      fileWriter = new FileWriter(exportFile, "utf-8");

    var ordersProcessed = [];
    Logger.info(['call-exportOrdersFile', exportFile]);

    while (searchOrders.hasNext() && (counter++ < limit)) {
          var orders = searchOrders.next();
          var orderMapping = new OrderMapping();
          var cordialOrder = orderMapping.execute(orders);

          if (counter % 2000 === 0 && counter) {
                fileWriter.close();

                cordial.PostJobOrders(exportFile.fullPath, options,
                      function (response) {
                            Logger.info('ordersExport file is submitted: ' + exportFilename);
                      },
                      function (response) {
                            errorFlag = true;
                            Logger.error('Post job error {0}', response);
                      }
                );

                // Update customer date flag
                ordersProcessed.forEach(function(order) {
                      Transaction.wrap(function () {
                        order.custom.cordialLastExported = newCordialOrdersDateUpdate;
                      });
                });
                ordersProcessed = [];

                exportFilename = exportFolder.fullPath + "orders_"
                        + helper.getTimestamp() + "_" + counter + ".json";
                exportFile = new File(exportFilename),
                fileWriter = new FileWriter(exportFile, "utf-8"),

                Logger.info(['exportOrdersFile-progress', counter + ' out of '
                    + searchOrders.getCount() + ' orders processed']);
          }

          fileWriter.writeLine(JSON.stringify(cordialOrder));

          ordersProcessed.push(orders);
    }

    //Clear resources
    fileWriter.close();

    Logger.info(['call-exportOrdersFile', newCordialOrdersDateUpdate, exportFilename, counter]);

    cordial.PostJobOrders(exportFile.fullPath, options,
          function (response) {
            Logger.info(['cordial.PostJobOrders-response', response]);
          },
          function (response) {
            errorFlag = true;
            Logger.error('Post job error {0}', response);
          }
    );

    // Update customer date flag
    ordersProcessed.forEach(function(order) {
          Transaction.wrap(function () {
            order.custom.cordialLastExported = newCordialOrdersDateUpdate;
            Logger.info(['update-order-cordialLastExported', order.UUID]);
          });
    });
    ordersProcessed = [];
  }

  if (errorFlag) {
    throw new Error('Job failed due to error(s) above.');
  }
}

module.exports = {
  exportOrders: exportOrders,
  exportOrdersFileTestRun: exportOrdersFileTestRun,
  longJobTestRun: longJobTestRun,
  exportOrdersFile: exportOrdersFile
};
