'use strict';

var ProductListMgr = require('dw/customer/ProductListMgr');

var Site = require('dw/system/Site');
var Transaction = require('dw/system/Transaction');
var Logger = require('dw/system/Logger');
var CustomObjectMgr = require('dw/object/CustomObjectMgr');
var cordial = require('~/cartridge/scripts/services/cordial');
var helper = require('~/cartridge/scripts/lib/mapping/helper/helper');

/**
 * exportWishlist
 * This function export products
 */
function exportWishlist(options) {
  var searchProductList;

  var lastRunObject = CustomObjectMgr.getCustomObject('CORDIAL_LASTRUN', 'cordialWishlistsDateUpdate');
  if (!lastRunObject) {
    Transaction.wrap(function () {
        lastRunObject =
            CustomObjectMgr.createCustomObject('CORDIAL_LASTRUN', 'cordialWishlistsDateUpdate');
    });
  }

  var cordialWishlistsDateUpdate = lastRunObject.custom.lastRunTime
        ? lastRunObject.custom.lastRunTime
        : Site.getCurrent().getCustomPreferenceValue('cordialWishlistsDateUpdate');

  var newCordialWishlistsDateUpdate = helper.getTime();
  var errorFlag = false;
  var supplementsName = 'sfcc__wishlist';

  if (cordialWishlistsDateUpdate) {
    searchProductList = ProductListMgr.queryProductLists('lastModified >= {0}', null, cordialWishlistsDateUpdate);
  } else {
    var date = newCordialWishlistsDateUpdate;
    searchProductList = ProductListMgr.queryProductLists('creationDate <= {0}', null, date);
  }

  while (searchProductList.hasNext()) {
    var productList = searchProductList.next();
    if (productList.getType() === 10) {
      cordial.PostProductList(productList, supplementsName, function () {}, function (response) {
        errorFlag = true;
        Logger.error('Import product List error {0} on post', response);
      });
    }
  }


  if (!errorFlag) {
        try {
            Transaction.wrap(function () {
                Site.getCurrent().setCustomPreferenceValue('cordialWishlistsDateUpdate',
                    newCordialWishlistsDateUpdate);
            });
            Transaction.wrap(function () {
                lastRunObject.custom.lastRunTime = newCordialWishlistsDateUpdate;
            });
        } catch (e) {
            Logger.info(['finish-exportWishlist', newCordialWishlistsDateUpdate]);
        }
  } else {
    throw new Error('Job failed due to error(s) above.');
  }
}

module.exports = {
  exportWishlist: exportWishlist
};
