'use strict';

var CustomerMgr = require('dw/customer/CustomerMgr');
var Site = require('dw/system/Site');
var Transaction = require('dw/system/Transaction');
var Logger = require('dw/system/Logger');
var FileReader = require('dw/io/FileReader');
var File = require('dw/io/File');
var CSVStreamReader = require('dw/io/CSVStreamReader');

/**
 *
 * This function import subscribe Statuses
 */
function importSubscribeStatus(options) {
  var cordialCustomersAddToEmailList = Site.getCurrent().getCustomPreferenceValue('cordialCustomersAddToEmailList');

  if (cordialCustomersAddToEmailList) {

    var exportFolderPath = File.IMPEX + "/subscriptions",
      exportFolder = new File(exportFolderPath);

    if (!exportFolder.exists()) {
      exportFolder.mkdirs();
    }

    var fileList = exportFolder.list();

    fileList.forEach(function (name) {
      var importFile = new File(exportFolder.fullPath + '/' + name);
      var CSVReader = new CSVStreamReader(new FileReader(importFile));
      var line = '';
      //line = CSVReader.readNext();

      while (line = CSVReader.readNext()) {
        var email = line[0];
        var addtoemaillist = line[1];
        var customer = CustomerMgr.getCustomerByLogin(email);
        if (customer) {
           try {
                Transaction.wrap(function () {
                    //customer.profile.custom[cordialCustomersAddToEmailList] =
                    //    addtoemaillist === 'subscribed' ? true : false;
                    customer.profile.custom.cordialSubscribed = addtoemaillist;
                });
           } catch(err) {
                Logger.error(err);
                Logger.error(email);
                //return false;
                throw new Error('Job failed due to error(s) above.');
           }
        }
      }

      CSVReader.close();
      importFile.remove();
    })
  }
}


module.exports = {
  importSubscribeStatus: importSubscribeStatus
};
