/*
 * map Sfcc model order
 *
 */

'use strict';

var helper = require('./helper/helper');
var Product = require('./product');

module.exports = function () {
  let self = {};

  var mapper = [{
      sf: 'productID',
      cordial: 'productID'
    },
    {
      sf: 'product.manufacturerSKU',
      sfBackup: 'productID',
      cordial: 'sku'
    },
    {
      sf: 'product.classificationCategory.ID',
      sfBackup: 'product.masterProduct.primaryCategory.ID',
      mandatory: 'productID',
      cordial: 'category'
    },
    {
      sf: 'productName',
      cordial: 'name'
    },
    {
      sf: 'product.shortDescription',
      sfBackup: 'product.longDescription',
      cordial: 'description'
    },
    {
      sf: 'quantityValue',
      cordial: 'qty'
    },
    {
      sf: 'priceValue',
      cordial: 'itemPrice'
    },
    {
      sf: 'product.pageURL',
      cordial: 'url'
    }
  ];

  self.execute = function (data) {
    var allProductLineItems =  data.getAllProductLineItems().toArray();
    var cordialCart = [];

    allProductLineItems.forEach(function(product){
      var cartitem = {};

      if (mapper && mapper.length > 0) {
        mapper.forEach(function (mSpecial) {
          var sfData = helper.get(product, mSpecial.sf);

          if (sfData) {
            helper.set(cartitem, mSpecial.cordial, sfData);
          } else if (mSpecial.sfBackup){
            var sfBackupData = helper.get(product, mSpecial.sfBackup);
            if (sfBackupData) {
              helper.set(cartitem, mSpecial.cordial, sfBackupData);
            } else if (mSpecial.mandatory) {
                var sfBackupData = helper.get(product, mSpecial.mandatory);
                if (sfBackupData) {
                  helper.set(cartitem, mSpecial.cordial, sfBackupData);
                }
            }
          }
        });
      }
      var variant = product.getProduct();

      if (variant) {
        var productVariation = variant.getVariationModel();
        if (productVariation) {
          var productVariationAttributes = productVariation.getProductVariationAttributes();
          var attr = {};
          if (productVariationAttributes) {
            productVariationAttributes.toArray().forEach(function(productVariationAttribute){
              var attributeID = productVariationAttribute.getAttributeID();
              attr[attributeID] = variant.custom[attributeID];
            });
          }
          cartitem.attr = attr;
        }
        //cartitem.images = variant.image ? [variant.image.getURL().toString()] : [];
        cartitem.images = helper.getAllImages(variant);
      } else {
        cartitem.attr = {};
      }


      cordialCart.push(cartitem);
    })

    return cordialCart;
  };

  return Object.freeze(self);
};
