/*
 * map Sfcc model order
 * 
 */
'use strict';

var helper = require('./helper/helper');

module.exports = function () {
  var self = {};

  // var mapper = [{
  //   sf: 'email',
  //   cordial: 'channels.email.address'
  // }];
  self.execute = function (data, mapSpecial) {
    var cordialCustomer = {};

    if (mapSpecial && mapSpecial.length > 0) {
      mapSpecial.forEach(function (mSpecial) {
        var sfData;

        if (mSpecial.sf == 'gender') {
          sfData = String(helper.get(data, mSpecial.sf) == 1 
            ? 'male' 
            : (helper.get(data, mSpecial.sf) == 2 
              ? 'female' 
              : 'undefined')
          );
        } else if (mSpecial.sf == 'custom.subscribed') {
          sfData = String(
            helper.get(data, mSpecial.sf)
            ? 'subscribed' 
            : 'none'
          );
        } else {
          sfData = helper.get(data, mSpecial.sf);
        }

        if (sfData) {
          helper.set(cordialCustomer, mSpecial.cordial, sfData);
        }
      });
    }

    return cordialCustomer;
  };

  return Object.freeze(self);
};
