'use strict';
var System = require('dw/system/System');
var Calendar = require('dw/util/Calendar');
var Site = require('dw/system/Site');
var Logger = require('dw/system/Logger');
var logger = Logger.getLogger('Cordial', 'cordialUtils-mapping-helper');

function get(obj, path, defaultValue) {
  try {
      return path.split(".").reduce(function (a, c) {
        return a && a[c] ? a[c] : defaultValue || null;
      }, obj);
  } catch (e) {
        return defaultValue || null;
  }
};

function set(obj, path, value) {
  if (Object(obj) !== obj) return obj; // When obj is not an object
  // If not yet an array, get the keys from the string-path
  if (!Array.isArray(path)) path = path.toString().match(/[^.[\]]+/g) || [];
  path.slice(0, -1).reduce(function (a, c, i) {
    return (// Iterate all of them except the last one
      Object(a[c]) === a[c] // Does the key exist and is its value an object?
      // Yes: then follow that path
      ? a[c]
      // No: create the key. Is the next key a potential array-index?
      : a[c] = Math.abs(path[i + 1]) >> 0 === +path[i + 1] ? [] // Yes: assign a new array object
      : {}
    );
  }, // No: assign a new plain object
  obj)[path[path.length - 1]] = value; // Finally assign the value to the last key
  return obj; // Return the top-level object to allow chaining
};

function flattenObject(ob) {
  var toReturn = {};

  for (var i in ob) {
      if (!ob.hasOwnProperty(i)) continue;
      toReturn[i] = ob[i];

      if ((typeof ob[i]) == 'object' && ob[i] !== null) {
          var flatObject = flattenObject(ob[i]);
          for (var x in flatObject) {
              if (!flatObject.hasOwnProperty(x)) continue;

              toReturn[i + '.' + x] = flatObject[x];
          }
      } else {
          toReturn[i] = ob[i];
      }
  }
  return toReturn;
}

function getTime() {
  var tzString =  System.getInstanceTimeZone();
  var calendar = new Calendar();

  calendar.setTimeZone(tzString);
  return calendar.getTime();
}

function getTimestamp() {
  var tzString =  System.getInstanceTimeZone();
  var calendar = new Calendar();

  calendar.setTimeZone(tzString);
  return calendar.get(6) + "_" + calendar.get(11) + "_" + calendar.get(12);
}

/**
 * function: getAllImages
 **/
function getAllImages(data) {
    var cordialProductImageTypes = Site.getCurrent().getCustomPreferenceValue('cordialProductImageTypes');

    cordialProductImageTypes = cordialProductImageTypes
        ? cordialProductImageTypes
        : ['small', 'medium'];

    var productImages = [];

    cordialProductImageTypes.forEach(function (view) {
        var images = data.getImages(view).length > 0 ? data.getImages(view).toArray() : [];
        if (images.length > 0) {
            images.forEach(function (image) {
                productImages.push(image.getAbsURL().toString());
            });
        }
    });

    return productImages;
}
  module.exports = {
    get: get,
    set: set,
    getAllImages: getAllImages,
    flattenObject: flattenObject,
    getTimestamp: getTimestamp,
    getTime: getTime
  };
