/**
 * Map Sfcc model order
 * 
 **/
var helper = require('./helper/helper');
var ProductMapping = require('./productLinetItem');
var ProductMgr = require('dw/catalog/ProductMgr');
var Logger = require('dw/system/Logger');

'use strict';

module.exports = function() {
  let self = {};

  var mapper = [{
    sf: 'orderNo',
    cordial: 'orderID'
  },
  {
    sf: 'customerEmail',
    cordial: 'email'
  },
  {
    sf: 'creationDate',
    cordial: 'purchaseDate'
  },
  {
    sf: 'defaultShipment.shippingAddress.fullName',
    cordial: 'shippingAddress.name'
  },
  {
    sf: 'defaultShipment.shippingAddress.address1',
    cordial: 'shippingAddress.address'
  },
  {
    sf: 'defaultShipment.shippingAddress.city',
    cordial: 'shippingAddress.city'
  },
  {
    sf: 'defaultShipment.shippingAddress.stateCode',
    cordial: 'shippingAddress.state'
  },
  {
    sf: 'defaultShipment.shippingAddress.postalCode',
    cordial: 'shippingAddress.postalCode'
  },
  {
    sf: 'defaultShipment.shippingAddress.countryCode.value',
    cordial: 'shippingAddress.country'
  },
  {
    sf: 'billingAddress.fullName',
    cordial: 'billingAddress.name'
  },
  {
    sf: 'billingAddress.address1',
    cordial: 'billingAddress.address'
  },
  {
    sf: 'billingAddress.city',
    cordial: 'billingAddress.city'
  },
  {
    sf: 'billingAddress.stateCode',
    cordial: 'billingAddress.state'
  },
  {
    sf: 'billingAddress.postalCode',
    cordial: 'billingAddress.postalCode'
  },
  {
    sf: 'billingAddress.countryCode.value',
    cordial: 'billingAddress.country'
  },
  {
    sf: 'totalTax.value',
    cordial: 'tax'
  },
  {
    sf: 'totalGrossPrice.value',
    cordial: 'totalAmount'
  },
  {
    sf: 'shippingTotalPrice.value',
    cordial: 'shippingAndHandling'
  }];

  self.execute = function (data) {
    // TODO 
    // "cID": "string",
    // "linkID": "string",
    // "mcID": "string",
    // "storeID": "string",
    // "customerID": 0,
    let cordialOrder = {properties: {}, shippingAddress: {}, billingAddress: {}};
    if (mapper && mapper.length > 0) {
      mapper.forEach(function (mSpecial) {
        var sfData = helper.get(data, mSpecial.sf);
        if (sfData) {
          helper.set(cordialOrder, mSpecial.cordial, sfData);
        } else if (mSpecial.sfBackup){
          var sfBackupData = helper.get(data, mSpecial.sfBackup);
          if (sfBackupData) {
            helper.set(cordialOrder, mSpecial.cordial, sfBackupData);
          }
        }
      });
    }

    var allProductLineItems =  data.getAllProductLineItems().toArray();
    cordialOrder.items = [];
    var productMapping = new ProductMapping();
    allProductLineItems.forEach(function(productLineItem){
      var product = ProductMgr.getProduct(productLineItem.productID)

      if (product) {
        var cordialProduct = productMapping.execute(product);
        cordialProduct.qty = productLineItem.quantity.value;
        //cordialProduct.itemPrice = productLineItem.getAdjustedPrice().value;
        cordialProduct.itemPrice = product.getPriceModel().getPrice().value;
        cordialOrder.items.push(cordialProduct);
      }
    });

  var statusArray = [
    'ORDER_STATUS_CREATED',
    '',
    '',
    'ORDER_STATUS_NEW',
    'ORDER_STATUS_OPEN',
    'ORDER_STATUS_COMPLETED',
    'ORDER_STATUS_CANCELLED',
    'ORDER_STATUS_REPLACED',
    'ORDER_STATUS_FAILED'
  ];

  var shippingStatusArray = [
    'SHIPPING_STATUS_NOTSHIPPED',
    'SHIPPING_STATUS_PARTSHIPPED',
    'SHIPPING_STATUS_SHIPPED'
  ]
    var statusValue = data.getStatus();
    cordialOrder.status = statusValue ? statusArray[statusValue.getValue()] : 'ORDER_STATUS_NEW';
    var shippingStatus = data.getShippingStatus();
    cordialOrder.properties.shippingStatus = shippingStatus ? shippingStatusArray[shippingStatus.getValue()] : 'SHIPPING_STATUS_NOTSHIPPED';

    return cordialOrder;
  };

  return Object.freeze(self);
};
