/*
 * map Sfcc model product
 *
 */

'use strict';

var helper = require('./helper/helper');
var ProductInventoryMgr = require('dw/catalog/ProductInventoryMgr');

module.exports = function() {
  var self = {};

  var mapper = [{
    sf: 'ID',
    cordial: 'productID'
  },
  {
    sf: 'name',
    sfBackup: 'ID',
    cordial: 'productName'
  },
  {
    sf: 'manufacturerName',
    cordial: 'manufacturerName'
  },
  {
    sf: 'priceModel.price.value',
    cordial: 'price'
  },
  {
    sf: 'primaryCategory.ID',
    cordial: 'category'
  },
  {
    sf: 'allCategories',
    cordial: 'properties.categories'
  },
  {
    sf: 'unitQuantity.available',
    cordial: 'inStock'
  },
  {
    sf: 'pageURL',
    cordial: 'url'
  }];

  self.execute = function (data) {
    if (!data) {
      return
    }
    let cordialProduct = {properties: {}};
    var mappedFlag = false;

    if (mapper && mapper.length > 0) {
      mapper.forEach(function (mSpecial) {
        var sfData = helper.get(data, mSpecial.sf);
        if (sfData) {
          helper.set(cordialProduct, mSpecial.cordial, sfData);
        } else if (mSpecial.sfBackup){
          var sfBackupData = helper.get(data, mSpecial.sfBackup);
          if (sfBackupData) {
            helper.set(cordialProduct, mSpecial.cordial, sfBackupData);
          }
        }
      });
    }

    cordialProduct.productType = data.isMaster() ? 'Master product' :
                                           data.isVariant() ? 'Variant' :
                                           data.isProduct() ? 'Product' :
                                           data.isOptionProduct() ? 'Option product' :
                                           data.isProductSet() ? 'Product sets' :
                                           data.isBundle() ? 'Product bundle' :
                                           data.isVariationGroup() ? 'Variation group product' :
                                           data.isProductSetProduct() ? 'Part product of set' :
                                           data.isBundled() ? 'Product bundled' : '';

    var variants = data.getVariants().toArray();
    cordialProduct.variants = [];
    var inventoryList = ProductInventoryMgr.getInventoryList();
    variants.forEach(function(variant){
      var cordialVariant = {};
      cordialVariant.sku = variant.getID();
      var productVariation = variant.getVariationModel();
      if (productVariation) {
        var productVariationAttributes = productVariation.getProductVariationAttributes();
        var attr = {};
        productVariationAttributes.toArray().forEach(function(productVariationAttribute){
          var attributeID = productVariationAttribute.getAttributeID();
          attr[attributeID] = variant.custom[attributeID];
        });
        cordialVariant.attr = attr;
      }
      var variantReacord = inventoryList.getRecord(variant);
      if (variantReacord) {
        cordialVariant.qty = variantReacord.isPerpetual() ? 9999 : variantReacord.getAllocation().value;
      } else {
        cordialVariant.qty = 0;
      }
      cordialProduct.variants.push(cordialVariant);
    })

    cordialProduct.taxable = !!(data.getTaxClassID());

    // map online status
    cordialProduct.enabled = !!(data.online);
    // TODO
    // "sale": {
    //   "enabled": true,
    //   "price": 0,
    //   "start": "2020-08-05",
    //   "end": "2020-08-05"
    // }


    // TODO get all images
    cordialProduct.images = helper.getAllImages(data);

    cordialProduct.UPCCode = data.getUPC();
    cordialProduct.tags = data.getPageMetaTags();

	// SF-66
    //
    // Map all categories from SFCC product to Cordial product
    // 2022-04-16
    cordialProduct.properties.categories = [];
    data.getAllCategories().toArray().forEach(category => {
        cordialProduct.properties.categories.push(category.ID);
    });

    return cordialProduct;
  };

  return Object.freeze(self);
};
