/*
 * map Sfcc model product
 *
 */

'use strict';

var helper = require('./helper/helper');

module.exports = function() {
  var self = {};
  var mapper = [{
    sf: 'ID',
    cordial: 'productID'
  },
  {
    sf: 'shortDescription',
    sfBackup: 'longDescription',
    cordial: 'description'
  },
  {
    sf: 'manufacturerSKU',
    sfBackup: 'ID',
    cordial: 'sku'
  },
  {
    sf: 'primaryCategory.ID',
    cordial: 'category'
  },
  {
    sf: 'name',
    sfBackup: 'ID',
    cordial: 'name'
  },
  {
    sf: 'unitQuantity.available',
    cordial: 'inStock'
  },
  {
    sf: 'online',
    cordial: 'enabled'
  },
  {
    sf: 'pageURL',
    cordial: 'url'
  }];

  self.execute = function (data) {
    // TODO
    // "salePrice": 0,

    if (!data) {
      return
    }

    var cordialProduct = {properties: {}, attr: {}};

    if (mapper && mapper.length > 0) {
      mapper.forEach(function (mSpecial) {
        var sfData = helper.get(data, mSpecial.sf);
        if (sfData) {
          helper.set(cordialProduct, mSpecial.cordial, sfData);
        } else if (mSpecial.sfBackup){
          var sfBackupData = helper.get(data, mSpecial.sfBackup);
          if (sfBackupData) {
            helper.set(cordialProduct, mSpecial.cordial, sfBackupData);
          }
        }
      });
    }

    cordialProduct.productType = data.isMaster() ? 'Master product' :
                               data.isVariant() ? 'Variant' :
                               data.isProduct() ? 'Product' :
                               data.isOptionProduct() ? 'Option product' :
                               data.isProductSet() ? 'Product sets' :
                               data.isBundle() ? 'Product bundle' :
                               data.isVariationGroup() ? 'Variation group product' :
                               data.isProductSetProduct() ? 'Part product of set' :
                               data.isBundled() ? 'Product bundled' : '';

    cordialProduct.taxable = !!(data.getTaxClassID());



    //TODO get all images
    cordialProduct.images = helper.getAllImages(data);

    cordialProduct.UPCCode = data.getUPC();
    cordialProduct.tags = data.getPageMetaTags();
    return cordialProduct;
  };

  return Object.freeze(self);
};
