/* API Modules */
var LocalServiceRegistry = require('dw/svc/LocalServiceRegistry');
var Site = require('dw/system/Site');
var StringUtils = require('dw/util/StringUtils');
var Logger = require('dw/system/Logger');

exports.getContacts = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("GET");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'contacts?email=' + encodeURIComponent(requestObj.email));
            return '';
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.postContacts = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("POST");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);

            svc.addParam('response_type', 'json');
            svc.setURL(svc.getURL() + 'contacts');

            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.updateContacts = function () {
    var service = LocalServiceRegistry.createService("cordial.rest", {
        createRequest: function (svc, requestObj, cordialCID) {
            svc.setRequestMethod("PUT");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'contacts/' + cordialCID);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.getOrders = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("GET");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'orders/' + requestObj);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.getProductList = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("GET");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'supplements/' + requestObj);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.postProductList = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("POST");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'supplements');

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.postProductListRecord = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj, supplementsName) {
            svc.setRequestMethod("POST");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'supplements/' + supplementsName + '/records');

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.deleteProductListRecord = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, productListID, supplementsName) {
            svc.setRequestMethod("DELETE");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'supplements/' + supplementsName + '/records/' + productListID);

            svc.addParam('response_type', 'json');
            return;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.postOrder = function () {
    var service = LocalServiceRegistry.createService("cordial.rest", {
        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("POST");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'orders');

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.updateOrder = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj, orderID) {
            svc.setRequestMethod("PUT");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'orders/' + orderID);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.postContactActivities = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            Logger.info('postContactactivities--url: {0}', svc.getURL() + 'contactactivities');
            svc.setRequestMethod("POST");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'contactactivities');

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            Logger.info('postContactactivities--response text: {0}', response.text);
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.getProducts = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("GET");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'products');

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.updateProducts = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("PUT");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);
            svc.setURL(svc.getURL() + 'products/?productID=' + requestObj.productID);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.postProducts = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj) {
            svc.setRequestMethod("POST");
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);

            svc.addParam('response_type', 'json');
            svc.setURL(svc.getURL() + 'products');

            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.updateCart = function () {

    var service = LocalServiceRegistry.createService("cordial.rest.updateCart", {

        createRequest: function (svc, requestObj, cid) {
            svc.setRequestMethod("PUT");
            var url = svc.getURL() + cid + '/cart'
            svc.setURL(url);
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.deleteCart = function () {

    var service = LocalServiceRegistry.createService("cordial.rest.deleteCart", {

        createRequest: function (svc, requestObj, cid) {
            svc.setRequestMethod("DELETE");
            var url = svc.getURL() + cid + '/cart'
            svc.setURL(url);
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.postJobCustomers = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj, cid) {
            svc.setRequestMethod("POST");
            var url = svc.getURL() + 'contactimports'
            svc.setURL(url);
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return false;
            //return msg;
        }
    });

    return service;
};

exports.postJobProducts = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj, cid) {
            svc.setRequestMethod("POST");
            var url = svc.getURL() + 'productimports'
            svc.setURL(url);
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};

exports.postJobOrders = function () {

    var service = LocalServiceRegistry.createService("cordial.rest", {

        createRequest: function (svc, requestObj, cid) {
            svc.setRequestMethod("POST");
            var url = svc.getURL() + 'ordersimport'
            svc.setURL(url);
            var apiCordialKey = Site.getCurrent().getCustomPreferenceValue('cordialApiKey');
            var key = 'Basic ' + StringUtils.encodeBase64(apiCordialKey + ':' + '');
            svc.addHeader('Content-Type', 'application/json');
            svc.addHeader('Authorization', key);

            svc.addParam('response_type', 'json');
            return requestObj;
        },
        parseResponse: function (svc, response ) {
            return response.text;
        },
        filterLogMessage: function (msg) {
            return msg;
        }
    });

    return service;
};
