function cordialOnSiteTags(crdlData) {
    if (crdlData.event === 'updating_cart') {
        var obj = [{
            event: 'cart',
            actionName: 'clear'
        }];

        if (crdlData.data.length) {
            obj.push({
                event: 'cartitem',
                actionName: 'add',
                data: crdlData.data
            });
        }

        obj.push({
            event: 'event',
            actionName: 'cart'
        });

        return JSON.stringify(obj);
    }

    if (crdlData.event === 'new_order') {
        var email = crdlData.data.email;
        var  properties = {
            'orderID': crdlData.data.orderID,
            'status': crdlData.data.status
        }
        delete crdlData.data.email;
        var obj = [
        {
            event: 'cart',
            actionName: 'clear',
        },
        {
            event: 'order',
            actionName: 'add',
            data: crdlData.data
        },
        {
            event: 'event',
            actionName: 'order',
            data: properties
        },
        {
            event: 'contact',
            actionName: {
                'email': email
            }
        }];
        return JSON.stringify(obj);
    }

    return JSON.stringify(crdlData)
}

module.exports = {
    cordialOnSiteTags: cordialOnSiteTags
};
