'use strict';

/* Script Modules */
var server = require('server');
var Logger = require('dw/system/Logger');
/* API Includes */
var ISML = require('dw/template/ISML');

/**
 * Controller that will send the necessary data required for cordial to track the user event's
 * such as checkout,order confirmation,searching etc and renders the renders the cordialTag isml file
 *
 * @module controllers/cordial
 */
server.get(
  'RenderCordial',
  server.middleware.https,
  function (req, res, next) {
    var logger = Logger;//.getLogger('renderCordial', 'cordial - Render cordial Controller');

    if (!dw.system.Site.getCurrent().getCustomPreferenceValue('cordialEnabledTag')) {
      return;
    }

    try {
      var cordialUtils = require('*/cartridge/scripts/utils/cordial/cordialUtils');
      var cordialTags = require('*/cartridge/scripts/utils/cordial/cordialOnSiteTags.js').cordialOnSiteTags;

      var cordialDataLayer = cordialUtils.buildDataLayer();
      var sendToDom = cordialTags(cordialDataLayer);

      var subscribed = customer && customer.profile && customer.profile.custom.cordialSubscribed;

      if (subscribed == 'yes') subscribed = 'subscribed';
      if (subscribed == 'no') subscribed = 'none';

      //var email = customer && customer.profile && customer.profile.email;
      var email = customer && customer.profile
        && customer.profile.credentials
        && customer.profile.credentials.login;

      if (cordialDataLayer.event === 'updating_cart' || cordialDataLayer.event === 'new_order') {
        ISML.renderTemplate('cordial/cordialTagCart', {
          cordialData: sendToDom,
          cordialEmail: email,
          subscribed: subscribed
        });
      } else {
        ISML.renderTemplate('cordial/cordialTag', {
          cordialData: sendToDom,
          cordialEmail: email,
          subscribed: subscribed
        });
      }
      next();
    } catch (e) {
      logger.debug('error rendering cordial_tag_v7: ' + e.message + ' at: ' + e.lineNumber);
    }
  }
);

/**
 * Controller that will send the necessary data  to cordial when an add to cart event happens
 * @module controllers/cordial
 */

server.get(
  'RenderCordialAddToCart',
  server.middleware.https,
  function (req, res, next) {
    if (!dw.system.Site.getCurrent().getCustomPreferenceValue('cordialEnabledTag')) {
      return;
    }
    var logger = Logger;//.getLogger('renderCordial', 'cordial - Render cordial add to cart Controller');

    try {
      var cordialUtils = require('*/cartridge/scripts/utils/cordial/cordialUtils');
      var cordialTags = require('*/cartridge/scripts/utils/cordial/cordialOnSiteTags.js').cordialOnSiteTags;

      var cordialDataLayer = cordialUtils.buildCartDataLayer();
      var sendToDom = cordialTags(cordialDataLayer);
      var email = customer && customer.profile && customer.profile.email;

      ISML.renderTemplate('cordial/cordialTagCart', {
        cordialData: sendToDom,
        cordialEmail: email
      });
      next();

    } catch (e) {
      logger.debug('error Render cordial add to cart ' + e.message + ' at ' + e.lineNumber);
    }

  }
);

server.get(
  'CordialAddToCartEvents',
  server.middleware.https,
  function (req, res, next) {

    if (!dw.system.Site.getCurrent().getCustomPreferenceValue('cordialEnabledTag')) {
      return;
    }
    var logger = Logger;//.getLogger('renderCordial', 'cordial - Render cordial add to cart Controller');

    try {
      var cordialUtils = require('*/cartridge/scripts/utils/cordial/cordialUtils');
      var cordialTags = require('*/cartridge/scripts/utils/cordial/cordialOnSiteTags.js').cordialOnSiteTags;

      var cordialDataLayer = cordialUtils.buildCartDataLayer();
      var sendToDom = cordialTags(cordialDataLayer);
      res.json({
        'data': sendToDom
      });

      next();

    } catch (e) {
      logger.debug('error Render cordial add to cart ' + e.message + ' at ' + e.lineNumber);
    }

  }
);


module.exports = server.exports();
