// cartUpdate
const cartActionRegex = /Cart-(AddProduct|EditProductLineItem|UpdateQuantity|RemoveProductLineItem)/

function updateCartCall() {
    var actionEl = document.querySelector('.renderCordialAddToCartAction')
    let formAction = actionEl.getAttribute("data-action");
    fetch(formAction, {
        method: 'GET'
      }).then((response) => {
        return response.json();
      })
      .then((data) => {
        var crdlParsedData = JSON.parse(data.data);

        if (typeof crdlParsedData.forEach === 'function') {
            crdlParsedData.forEach(element => {
              if ( element.data) {
                crdl(element.event, element.actionName, element.data);
                console.log(element.event, element.actionName, element.data)
              } else {
                if (element.event === 'contact') {
                  var emailCordial = sessionStorage.getItem('emailCordial');
                  if (!emailCordial) {
                    crdl(element.event, element.actionName);
                    crdl('forget');
                  }
                } else {
                  crdl(element.event, element.actionName);
                  console.log(element.event, element.actionName)
                }
              }
            });
        }
      });
}

function shouldUpdateCart(url) {
    const res = cartActionRegex.test(url);
    return res;
}

function cartUpdate (urlPath) {
    if ( !shouldUpdateCart(urlPath)) {
        return;
    }
    
    setTimeout(updateCartCall, 0)
}

//xmlHttpListener
const send = window.XMLHttpRequest.prototype.send;

function sendReplacement() {
    const onLoad = this.onload;
    function ourOnLoad() {
        if (this && this.response) {
            try {
              var response = JSON.parse(this.response)
              if (response && response.action) {
                  cartUpdate(response.action);
              }
            } catch (e) {
           }
        }

        if (onLoad) {
          return onLoad.apply(this, arguments);
        }
    }

    //Object.defineProperty(this, 'onload', ourOnLoad);
    this.onload = ourOnLoad;

    return send.apply(this, arguments);
}

window.XMLHttpRequest.prototype.send = sendReplacement;

// fetchListener
(function(ns, fetch){
    if(typeof fetch !== 'function') return;
    ns.fetch = function() {
        var out = fetch.apply(this, arguments);
        out.then(function(e){
            if (this && this.response) {
                var response = JSON.parse(this.response)
                if (response && response.action) {
                    cartUpdate(response.action);
                }
            }
        });
        return out;
    }
}(window, window.fetch))
